/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.util.Hashtable;

public class VWWorkBasketDefinition
extends VWMLABase
implements Serializable,
Cloneable,
IVWtoXML {
    private static final long serialVersionUID = 7464L;
    protected transient VWQueueDefinition m_myQueueDef = null;
    protected String m_myQueueName = null;
    protected String m_name = null;
    private String m_description = null;
    private String m_indexName = null;
    private String m_queryFilterString = null;
    private int m_flagsForWorkBasket;
    protected static final int WBShowAllUsersWork = 1;
    protected static final String F_WBFlags = "*F_WBFlags";
    private VWWorkBasketColumnDefinition[] m_workBasketColumnDefs = new VWWorkBasketColumnDefinition[0];
    private VWArrayHandler m_workBasketColumnDefHandler = new VWArrayHandler();
    private VWWorkBasketFilterDefinition[] m_workBasketFilterDefs = new VWWorkBasketFilterDefinition[0];
    private VWArrayHandler m_workBasketFilterDefHandler = new VWArrayHandler();
    protected Hashtable m_attributes = null;
    protected int m_nRevision = 0;
    protected int m_nObjId = 0;
    private boolean m_bHasChanged = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:21:51 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/3 $";
    }

    protected VWWorkBasketDefinition(int revision, String name, VWQueueDefinition queueDef) throws VWException {
        this.m_nRevision = revision;
        this.setMyQueueDefinition(queueDef);
        this.setName(name);
    }

    protected VWWorkBasketDefinition(int revision, String name, String description, String indexName, String queueQueryFilter, VWWorkBasketColumnDefinition[] columns, VWWorkBasketFilterDefinition[] adHocFilters, VWAttributeInfo attributes, VWQueueDefinition qDef, String queueName, int objId) throws VWException {
        Integer myFlags;
        this.m_nRevision = revision;
        this.m_name = name;
        this.m_description = description;
        this.m_indexName = indexName;
        this.m_queryFilterString = queueQueryFilter;
        this.m_nObjId = objId;
        int nColumns = columns == null ? 0 : columns.length;
        for (int i = 0; i < nColumns; ++i) {
            this.addWorkBasketColumnDefinition(columns[i]);
        }
        int nFilters = adHocFilters == null ? 0 : adHocFilters.length;
        for (int i = 0; i < nFilters; ++i) {
            this.addWorkBasketFilterDefinition(adHocFilters[i]);
        }
        if (attributes != null && (myFlags = (Integer)attributes.getFieldValue(F_WBFlags)) != null) {
            this.m_flagsForWorkBasket = myFlags;
            attributes.deleteField(F_WBFlags);
            String[] attrNames = attributes.getAttributeNames();
            if (attrNames == null || attrNames.length < 1) {
                attributes = null;
            }
        }
        this.setAttributeInfo(attributes);
        this.setMyQueueDefinition(qDef);
        if (qDef != null) {
            qDef.addWorkBasketDefinition(this);
        }
        this.m_myQueueName = queueName;
    }

    public int getObjId() throws VWException {
        return this.m_nObjId;
    }

    public int getRevision() throws VWException {
        return this.m_nRevision;
    }

    public String getName() throws VWException {
        return this.translateStr(this.m_name);
    }

    public String getAuthoredName() throws VWException {
        return this.translateToAuthored(this.m_name);
    }

    public void setName(String theName) throws VWException {
        if (theName != null) {
            theName = theName.trim();
        }
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWWorkBasketDefinitionInvalidName", "The in-basket name is invalid, (null or zero length).");
        }
        if (theName.equals(this.m_name)) {
            return;
        }
        if (theName.length() > 128) {
            throw new VWException("vw.api.VWWorkBasketDefinitionNameTooLong", "The in-basket name can not exceed 128 characters).");
        }
        if (theName.startsWith("~")) {
            throw new VWException("vw.api.VWWorkBasketDefinitionName.InvalidSartChar", "The in-basket name can not start with ''~''.");
        }
        VWWorkBasketDefinition tmpWBDef = null;
        try {
            if (this.m_myQueueDef != null) {
                tmpWBDef = this.m_myQueueDef.getWorkBasketDefinition(theName);
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (tmpWBDef != null) {
            throw new VWException("vw.api.VWWorkBasketDefinition.workbasketAlreadyExists", "An in-basket definition with that name already exists.");
        }
        this.m_name = theName;
        this.setHasChanged(true);
    }

    public String getDescription() throws VWException {
        if (this.m_description != null) {
            return this.translateStr(this.m_description);
        }
        return null;
    }

    public void setDescription(String description) throws VWException {
        this.m_description = description;
        this.setHasChanged(true);
    }

    public String getQueueName() throws VWException {
        return this.m_myQueueName;
    }

    public String getQueryFilterString() throws VWException {
        return this.m_queryFilterString;
    }

    public void setQueryFilterString(String queryFilter) throws VWException {
        this.m_queryFilterString = queryFilter;
        this.setHasChanged(true);
    }

    public String getIndexName() throws VWException {
        if (this.m_indexName != null && this.m_indexName.trim().length() == 0) {
            return null;
        }
        return this.translateStr(this.m_indexName);
    }

    public void setIndexName(String indexName) throws VWException {
        if (indexName != null) {
            if ((indexName = indexName.trim()).length() == 0) {
                indexName = null;
            } else if (this.m_myQueueDef != null) {
                if (this.m_myQueueDef.getIndex(indexName) == null) {
                    throw new VWException("vw.api.VWWorkBasketDefinition.IndexDoesNotExist", "Failed to set the index name \"{0}\" - the index does not exist in the queue.", indexName);
                }
            } else {
                throw new VWException("vw.api.VWWorkBasketDefinition.queueIsNull", "Failed to set the index name \"{0}\" - the queue definition object can not be null.", indexName);
            }
        }
        this.m_indexName = indexName;
        this.setHasChanged(true);
    }

    public VWWorkBasketColumnDefinition getWorkBasketColumnDefinition(String workBasketColumnName) throws VWException {
        if (workBasketColumnName == null || workBasketColumnName.trim().length() == 0) {
            throw new VWException("vw.api.VWWorkBasketDefinition.getWBCDefWithNullName", "Cannot get an in-basket column definition with a null or empty name");
        }
        int nIndex = this.getWorkBasketColumnDefinitionIndex(workBasketColumnName);
        if (nIndex == -1) {
            return null;
        }
        return this.m_workBasketColumnDefs[nIndex];
    }

    public VWWorkBasketColumnDefinition[] getWorkBasketColumnDefinitions() throws VWException {
        if (this.m_workBasketColumnDefHandler.getElementCount() > 0) {
            this.m_workBasketColumnDefs = (VWWorkBasketColumnDefinition[])this.m_workBasketColumnDefHandler.getElements(this.m_workBasketColumnDefs);
            return this.m_workBasketColumnDefs;
        }
        return null;
    }

    public VWWorkBasketColumnDefinition createWorkBasketColumnDefinition(String prompt, VWExposedFieldDefinition column) throws VWException {
        if (column == null) {
            throw new VWException("vw.api.VWWorkBasketDefinition.ExposedFieldDefNull", "The exposed field definition can not be null when creating an in-basket column definition.");
        }
        if (this.getWorkBasketColumnDefinitionIndex(column.getName()) != -1) {
            throw new VWException("vw.api.VWWorkBasketDefinition.workbasketColumnDefinitionAlreadyExists", "An in-basket column definition with that name already exists.");
        }
        VWWorkBasketColumnDefinition newWorkBasketColumnDef = new VWWorkBasketColumnDefinition(prompt, column, this);
        this.m_workBasketColumnDefs = (VWWorkBasketColumnDefinition[])this.m_workBasketColumnDefHandler.addElementToArray(this.m_workBasketColumnDefs, newWorkBasketColumnDef);
        this.setHasChanged(true);
        return newWorkBasketColumnDef;
    }

    private void addWorkBasketColumnDefinition(VWWorkBasketColumnDefinition wbColumnDef) throws VWException {
        if (wbColumnDef == null) {
            return;
        }
        int nIndex = this.getWorkBasketColumnDefinitionIndex(wbColumnDef.getName());
        if (nIndex != -1) {
            throw new VWException("vw.api.VWQueueDefinition.workbasketAlreadyExists", "An in-basket column definition with that name already exists.");
        }
        wbColumnDef.setMyWorkBasketDefinition(this);
        this.m_workBasketColumnDefs = (VWWorkBasketColumnDefinition[])this.m_workBasketColumnDefHandler.addElementToArray(this.m_workBasketColumnDefs, wbColumnDef);
        this.setHasChanged(true);
    }

    public VWWorkBasketColumnDefinition deleteWorkBasketColumnDefinition(String workBasketColumnName) throws VWException {
        if (workBasketColumnName == null) {
            throw new VWException("vw.api.VWWorkBasketDefinition.WorkBasketColumnDeleteWithNullName", "Cannot delete an in-basket column with a null name");
        }
        int nIndex = this.getWorkBasketColumnDefinitionIndex(workBasketColumnName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWWorkBasketDefinition.workBasketColumnNotFound", "No in-basket column found with name equal to \"{0}\".", workBasketColumnName);
        }
        VWWorkBasketColumnDefinition workbasketColumnDef = this.m_workBasketColumnDefs[nIndex];
        this.m_workBasketColumnDefHandler.deleteElementFromArray(this.m_workBasketColumnDefs, nIndex);
        this.setHasChanged(true);
        return workbasketColumnDef;
    }

    public void setWorkBasketColumnDefinitions(VWWorkBasketColumnDefinition[] workBasketColumnDefs) throws VWException {
        this.m_workBasketColumnDefs = new VWWorkBasketColumnDefinition[0];
        this.m_workBasketColumnDefHandler = new VWArrayHandler();
        this.m_workBasketColumnDefs = (VWWorkBasketColumnDefinition[])this.m_workBasketColumnDefHandler.getElements(this.m_workBasketColumnDefs);
        if (workBasketColumnDefs != null && workBasketColumnDefs.length > 0) {
            for (int i = 0; i < workBasketColumnDefs.length; ++i) {
                if (workBasketColumnDefs[i] == null) continue;
                this.m_workBasketColumnDefs = (VWWorkBasketColumnDefinition[])this.m_workBasketColumnDefHandler.addElementToArray(this.m_workBasketColumnDefs, workBasketColumnDefs[i]);
            }
        }
        this.setHasChanged(true);
    }

    public VWWorkBasketFilterDefinition getWorkBasketFilterDefinition(String workBasketFilterName) throws VWException {
        if (workBasketFilterName == null || workBasketFilterName.trim().length() == 0) {
            throw new VWException("vw.api.VWWorkBasketDefinition.getWBFDefWithNullName", "Cannot get an in-basket filter definition with a null or empty name");
        }
        VWWorkBasketFilterDefinition[] filterDefs = this.getWorkBasketFilterDefinitions();
        VWWorkBasketFilterDefinition result = null;
        String tmpdefName = null;
        String tmpdefAuthoredName = null;
        if (filterDefs != null) {
            for (int i = 0; i < filterDefs.length; ++i) {
                if (filterDefs[i] == null) continue;
                tmpdefName = filterDefs[i].getName();
                tmpdefAuthoredName = filterDefs[i].getAuthoredName();
                if ((tmpdefName == null || !workBasketFilterName.equals(tmpdefName)) && (tmpdefAuthoredName == null || !workBasketFilterName.equals(tmpdefAuthoredName))) continue;
                result = filterDefs[i];
                break;
            }
        }
        return result;
    }

    public VWWorkBasketFilterDefinition[] getWorkBasketFilterDefinitions() throws VWException {
        if (this.m_workBasketFilterDefHandler.getElementCount() > 0) {
            this.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])this.m_workBasketFilterDefHandler.getElements(this.m_workBasketFilterDefs);
            return this.m_workBasketFilterDefs;
        }
        return null;
    }

    public VWWorkBasketFilterDefinition createWorkBasketFilterDefinition(String workBasketFilterName) throws VWException {
        return this.createWorkBasketFilterDefinition(workBasketFilterName, 0);
    }

    protected VWWorkBasketFilterDefinition createWorkBasketFilterDefinition(String workBasketFilterName, int revision) throws VWException {
        if (workBasketFilterName == null || workBasketFilterName.trim().length() == 0) {
            throw new VWException("vw.api.VWWorkBasketDefinition.creaetWBFDefWithNullName", "Cannot create an in-basket filter definition with a null or empty name");
        }
        int nIndex = this.m_workBasketFilterDefHandler.getIndexFromStringFieldValue(this.m_workBasketFilterDefs, "m_name", workBasketFilterName);
        if (nIndex != -1) {
            throw new VWException("vw.api.VWWorkBasketDefinition.workbasketFilterAlreadyExists", "An in-basket filter definition with that name already exists.");
        }
        VWWorkBasketFilterDefinition newWorkBasketFilterDef = new VWWorkBasketFilterDefinition(workBasketFilterName, this);
        this.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])this.m_workBasketFilterDefHandler.addElementToArray(this.m_workBasketFilterDefs, newWorkBasketFilterDef);
        this.setHasChanged(true);
        return newWorkBasketFilterDef;
    }

    private void addWorkBasketFilterDefinition(VWWorkBasketFilterDefinition wbFilterDef) throws VWException {
        if (wbFilterDef == null) {
            return;
        }
        int nIndex = this.m_workBasketFilterDefHandler.getIndexFromStringFieldValue(this.m_workBasketFilterDefs, "m_name", wbFilterDef.getName());
        if (nIndex != -1) {
            throw new VWException("vw.api.VWQueueDefinition.workbasketAlreadyExists", "An in-basket definition with that name already exists.");
        }
        wbFilterDef.setMyWorkBasketDefinition(this);
        this.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])this.m_workBasketFilterDefHandler.addElementToArray(this.m_workBasketFilterDefs, wbFilterDef);
        this.setHasChanged(true);
    }

    public VWWorkBasketFilterDefinition deleteWorkBasketFilterDefinition(String workBasketFilterName) throws VWException {
        if (workBasketFilterName == null) {
            throw new VWException("vw.api.VWWorkBasketDefinition.WorkBasketFilterDeleteWithNullName", "Cannot delete an in-basket filter definition with a null name or empty name");
        }
        int nIndex = this.m_workBasketFilterDefHandler.getIndexFromStringFieldValue(this.m_workBasketFilterDefs, "m_name", workBasketFilterName);
        if (nIndex == -1) {
            throw new VWException("vw.api.VWWorkBasketDefinition.workBasketFilterNotFound", "No in-basket filter found with name equal to \"{0}\".", workBasketFilterName);
        }
        VWWorkBasketFilterDefinition workbasketFilterDef = this.m_workBasketFilterDefs[nIndex];
        this.m_workBasketFilterDefHandler.deleteElementFromArray(this.m_workBasketFilterDefs, nIndex);
        this.setHasChanged(true);
        return workbasketFilterDef;
    }

    public VWWorkBasketFilterDefinition createCopyOfWorkBasketFilterDefinition(String workBasketFilterName, VWWorkBasketFilterDefinition origWorkBasketFilterDef) throws VWException {
        if (workBasketFilterName == null || workBasketFilterName.trim().length() == 0) {
            throw new VWException("vw.api.VWWorkBasketDefinition.creaetCopyOfWBFDefWithNullName", "The destination in-basket filter definition name can not be null or empty");
        }
        if (origWorkBasketFilterDef == null) {
            throw new VWException("vw.api.VWWorkBasketDefinition.NullSourceWorkBasketFilterDefinition", "The source in-basket filter definition is null.");
        }
        VWWorkBasketFilterDefinition newWorkBasketFilterDef = (VWWorkBasketFilterDefinition)origWorkBasketFilterDef.clone();
        if (newWorkBasketFilterDef != null) {
            newWorkBasketFilterDef.setName(workBasketFilterName);
            this.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])this.m_workBasketFilterDefHandler.addElementToArray(this.m_workBasketFilterDefs, newWorkBasketFilterDef);
            this.setHasChanged(true);
        }
        return newWorkBasketFilterDef;
    }

    public void setWorkBasketFilterDefinitions(VWWorkBasketFilterDefinition[] workBasketFilterDefs) throws VWException {
        this.m_workBasketFilterDefs = new VWWorkBasketFilterDefinition[0];
        this.m_workBasketFilterDefHandler = new VWArrayHandler();
        this.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])this.m_workBasketFilterDefHandler.getElements(this.m_workBasketFilterDefs);
        if (workBasketFilterDefs != null && workBasketFilterDefs.length > 0) {
            for (int i = 0; i < workBasketFilterDefs.length; ++i) {
                if (workBasketFilterDefs[i] == null) continue;
                this.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])this.m_workBasketFilterDefHandler.addElementToArray(this.m_workBasketFilterDefs, workBasketFilterDefs[i]);
            }
        }
        this.setHasChanged(true);
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.m_attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        this.setHasChanged(true);
        if (theAttributeInfo != null) {
            Hashtable theAttributes;
            Integer myFlags = (Integer)theAttributeInfo.getFieldValue(F_WBFlags);
            if (myFlags != null) {
                this.m_flagsForWorkBasket = myFlags;
                theAttributeInfo.deleteField(F_WBFlags);
                String[] attrNames = theAttributeInfo.getAttributeNames();
                if (attrNames == null || attrNames.length < 1) {
                    theAttributeInfo = null;
                }
            }
            this.m_attributes = theAttributes = theAttributeInfo.attributes;
        } else {
            this.m_attributes = null;
        }
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        Integer myFlags;
        if (theAttributes != null && (myFlags = (Integer)theAttributes.get(F_WBFlags)) != null) {
            this.m_flagsForWorkBasket = myFlags;
            theAttributes.remove(F_WBFlags);
            if (theAttributes.size() < 1) {
                theAttributes = null;
            }
        }
        this.m_attributes = theAttributes;
    }

    protected VWAttributeInfo getAttributes() throws VWException {
        VWAttributeInfo theAttributes = new VWAttributeInfo(this.m_attributes);
        if (theAttributes != null && this.m_flagsForWorkBasket != 0) {
            theAttributes.setFieldValue(F_WBFlags, this.m_flagsForWorkBasket);
        }
        return theAttributes;
    }

    public String toString() {
        return this.m_name;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void setObjId(int theNewObjId) throws VWException {
        if (theNewObjId < 0) {
            throw new VWException("vw.api.VWWorkBasketDefObjIdErr", "The object id can not be a negative value.");
        }
        this.m_nObjId = theNewObjId;
        this.setHasChanged(true);
    }

    protected boolean hasChanged() throws VWException {
        return this.m_bHasChanged;
    }

    protected void setHasChanged(boolean theNewValue) throws VWException {
        this.m_bHasChanged = theNewValue;
        if (this.m_myQueueDef != null) {
            this.m_myQueueDef.setHasChanged(theNewValue);
        }
    }

    protected Object clone() {
        try {
            int i;
            VWWorkBasketDefinition workbasketDef = (VWWorkBasketDefinition)super.clone();
            try {
                workbasketDef.m_workBasketColumnDefHandler = new VWArrayHandler();
                workbasketDef.m_workBasketColumnDefs = new VWWorkBasketColumnDefinition[0];
                if (this.m_workBasketColumnDefs != null) {
                    VWWorkBasketColumnDefinition workBasketColumnDef = null;
                    for (i = 0; i < this.m_workBasketColumnDefs.length; ++i) {
                        if (this.m_workBasketColumnDefs[i] == null) continue;
                        workBasketColumnDef = (VWWorkBasketColumnDefinition)this.m_workBasketColumnDefs[i].clone();
                        workBasketColumnDef.setMyWorkBasketDefinition(workbasketDef);
                        workbasketDef.m_workBasketColumnDefs = (VWWorkBasketColumnDefinition[])workbasketDef.m_workBasketColumnDefHandler.addElementToArray(workbasketDef.m_workBasketColumnDefs, workBasketColumnDef);
                    }
                }
            }
            catch (VWException ex) {
                // empty catch block
            }
            try {
                workbasketDef.m_workBasketFilterDefHandler = new VWArrayHandler();
                workbasketDef.m_workBasketFilterDefs = new VWWorkBasketFilterDefinition[0];
                if (this.m_workBasketFilterDefs != null) {
                    VWWorkBasketFilterDefinition workBasketFilterDef = null;
                    for (i = 0; i < this.m_workBasketFilterDefs.length; ++i) {
                        if (this.m_workBasketFilterDefs[i] == null) continue;
                        workBasketFilterDef = (VWWorkBasketFilterDefinition)this.m_workBasketFilterDefs[i].clone();
                        workBasketFilterDef.setMyWorkBasketDefinition(workbasketDef);
                        workbasketDef.m_workBasketFilterDefs = (VWWorkBasketFilterDefinition[])workbasketDef.m_workBasketFilterDefHandler.addElementToArray(workbasketDef.m_workBasketFilterDefs, workBasketFilterDef);
                    }
                }
            }
            catch (VWException vWException) {
                // empty catch block
            }
            if (this.m_attributes != null) {
                workbasketDef.m_attributes = (Hashtable)this.m_attributes.clone();
            }
            return workbasketDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        int i;
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAppliationSpaceDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "InBasketDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.m_name) + "\"\n");
        theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.m_description) + "\"\n");
        theBuffer.append(INDENT_1 + "IndexName" + "=\"" + VWXMLHandler.toXMLString(this.m_indexName) + "\"\n");
        theBuffer.append(INDENT_1 + "QueueFilterString" + "=\"" + VWXMLHandler.toXMLString(this.m_queryFilterString) + "\"\n");
        theBuffer.append(INDENT_1 + "ObjectId" + "=\"" + this.getObjId() + "\"\n");
        theBuffer.append(INDENT_1 + "Revision" + "=\"" + this.getRevision() + "\"");
        theBuffer.append(">\n");
        if (this.m_workBasketColumnDefs != null) {
            theBuffer.append(INDENT_1 + "<" + "ArrayOfInBasketColumnDefinition" + ">\n");
            if (this.m_workBasketColumnDefs != null && this.m_workBasketColumnDefs.length > 0) {
                for (i = 0; i < this.m_workBasketColumnDefs.length; ++i) {
                    if (this.m_workBasketColumnDefs[i] == null) continue;
                    this.m_workBasketColumnDefs[i].toXML(theBuffer, INDENT_2);
                }
            }
            theBuffer.append(INDENT_1 + "</" + "ArrayOfInBasketColumnDefinition" + ">\n");
        }
        if (this.m_workBasketFilterDefs != null) {
            theBuffer.append(INDENT_1 + "<" + "ArrayOfInBasketFilterDefinition" + ">\n");
            if (this.m_workBasketFilterDefs != null && this.m_workBasketFilterDefs.length > 0) {
                for (i = 0; i < this.m_workBasketFilterDefs.length; ++i) {
                    if (this.m_workBasketFilterDefs[i] == null) continue;
                    this.m_workBasketFilterDefs[i].toXML(theBuffer, INDENT_2);
                }
            }
            theBuffer.append(INDENT_1 + "</" + "ArrayOfInBasketFilterDefinition" + ">\n");
        }
        VWAttributeInfo theAttributeInfo = this.getAttributes();
        theAttributeInfo.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_0 + "</" + "InBasketDefinition" + ">\n");
    }

    protected void removeReferences() {
        int i;
        this.m_name = null;
        this.m_description = null;
        this.m_indexName = null;
        this.m_queryFilterString = null;
        this.m_myQueueDef = null;
        if (this.m_attributes != null) {
            this.m_attributes.clear();
        }
        this.m_attributes = null;
        if (this.m_workBasketColumnDefs != null && this.m_workBasketColumnDefs.length >= 0) {
            for (i = 0; i < this.m_workBasketColumnDefs.length; ++i) {
                this.m_workBasketColumnDefs[i] = null;
            }
        }
        this.m_workBasketColumnDefs = null;
        this.m_workBasketColumnDefHandler = null;
        if (this.m_workBasketFilterDefs != null && this.m_workBasketFilterDefs.length >= 0) {
            for (i = 0; i < this.m_workBasketFilterDefs.length; ++i) {
                this.m_workBasketFilterDefs[i] = null;
            }
        }
        this.m_workBasketFilterDefs = null;
        this.m_workBasketFilterDefHandler = null;
    }

    protected int getWorkBasketColumnDefinitionIndex(String name) throws VWException {
        if (name == null || name.trim().length() == 0) {
            throw new VWException("vw.api.VWWorkBasketDefinition.getWBCDefIndexWithNullName", "Cannot get an in-basket column definition index using a null or empty name");
        }
        VWWorkBasketColumnDefinition[] columnDefs = this.getWorkBasketColumnDefinitions();
        int nIndex = -1;
        String tmpdefName = null;
        String tmpdefAuthoredName = null;
        if (columnDefs != null && columnDefs.length > 0) {
            for (int i = 0; i < columnDefs.length; ++i) {
                if (columnDefs[i] == null) continue;
                tmpdefName = columnDefs[i].getName();
                tmpdefAuthoredName = columnDefs[i].getAuthoredName();
                if ((tmpdefName == null || !name.equals(tmpdefName)) && (tmpdefAuthoredName == null || !name.equals(tmpdefAuthoredName))) continue;
                nIndex = i;
                break;
            }
        }
        return nIndex;
    }

    protected void initWorkBasketFromOrb() throws VWException {
        VWWorkBasketColumnDefinition[] columnDefs;
        VWWorkBasketFilterDefinition[] filterDefs = this.getWorkBasketFilterDefinitions();
        if (filterDefs != null && filterDefs.length > 0) {
            for (int i = 0; i < filterDefs.length; ++i) {
                if (filterDefs[i] == null) continue;
                filterDefs[i].setMyWorkBasketDefinition(this);
                filterDefs[i].initSearchFieldFromORB();
            }
        }
        if ((columnDefs = this.getWorkBasketColumnDefinitions()) != null && columnDefs.length > 0) {
            for (int i = 0; i < columnDefs.length; ++i) {
                if (columnDefs[i] == null) continue;
                columnDefs[i].setMyWorkBasketDefinition(this);
                columnDefs[i].initColumnFromOrb();
            }
        }
    }

    protected void setMyQueueDefinition(VWQueueDefinition queueDef) throws VWException {
        this.m_myQueueDef = queueDef;
        if (queueDef != null) {
            this.m_myQueueName = queueDef.getName();
            super.setSession(queueDef.getSession());
        }
    }

    protected void reset() throws VWException {
        this.m_description = null;
        this.m_indexName = null;
        this.m_queryFilterString = null;
        this.m_workBasketColumnDefs = new VWWorkBasketColumnDefinition[0];
        this.m_workBasketColumnDefHandler = new VWArrayHandler();
        this.m_workBasketFilterDefs = new VWWorkBasketFilterDefinition[0];
        this.m_workBasketFilterDefHandler = new VWArrayHandler();
        this.m_attributes = null;
        this.m_nRevision = 0;
        this.m_nObjId = 0;
        this.m_flagsForWorkBasket = 0;
        this.setHasChanged(true);
    }

    public boolean isShowWorkForAllUsers() {
        return (this.m_flagsForWorkBasket & 1) != 0;
    }

    public void setShowWorkForAllUsers(boolean setting) throws VWException {
        this.m_flagsForWorkBasket = setting ? (this.m_flagsForWorkBasket |= 1) : (this.m_flagsForWorkBasket &= 0xFFFFFFFE);
        this.setHasChanged(true);
    }

    protected int getWbFlags() {
        return this.m_flagsForWorkBasket;
    }
}

